function [X, M_C,R, CL, S ] = signal_considering_coupling(design, doas, wavelength, t, ncov, scov,coupling_para)

position_SA = design.element_indices;
position_SA = position_SA(:);
nnn = length(position_SA);
P = repmat(position_SA', nnn, 1);
D = P' - P; % D_ij = d_i - d_j
% ==================== Mutual coupling parameters ====================
c1=coupling_para;
cc=[];
cc(1)=c1;
for pp=2:100
    cc(pp) = c1*exp(-i*(pp-1)*pi/8)/pp;
end

S = 1;
% ==================== Mutual Coupling matrix computing =====================
M_C = eye(nnn);
for    ppp=1:100
       M_C( abs(D) == ppp) = cc(ppp);
end
% ==================== Coupling Leakage ================================
CL = M_C-diag(diag(M_C));
CL = norm(CL)/norm(M_C);
% ======================================================================
A = steering_matrix(design, wavelength, doas);
[m, k] = size(A);
S_internal = gen_ccsg(k, t, scov);
X = M_C*A * S_internal + gen_ccsg(m, t, ncov);
if nargout >= 2
    R = (X*X')/t;
    if nargout == 4
        S = S_internal;
    end
end
end



function X = gen_ccsg(m, n, cov)
X0 = randn(m, n) + 1j * randn(m, n);
if isscalar(cov)
    X = sqrt(cov/2) * X0;
elseif isvector(cov)
    X = bsxfun(@times, X0, cov(:));
else
    C = sqrtm(cov/2);
    X = C*X0;
end
end